<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="utf-8" />
<title>PinDown Distance Markers</title>
<meta name="description" content="PinDown Distance Markers - a LuxSoft product">
<meta name="application-name" content="PDM V20250829">
<meta name="author" content="LuxSoft Europe">
<meta name="robots" content="nofollow">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<style type="text/css">
body {padding:40px; font:14px arial, sans-serif; background:#E0E0D0; color:#2B3856;}
</style>
</head>

<body>
<h3>Produce Distances Markers File</h3>
<br>
<?php
//geojson file components

//point template
$gjPointsT = ',{
			"type": "Feature",
			"geometry": {
				"type": "Point",
				"coordinates": [<lola>]
			},
			"properties": {
				"distance": "<dist>",
				"description": "<desc>",
				"radius": 4,
				"stroke": "#00F",
				"stroke-width": 2,
				"stroke-opacity": 1,
				"fill": "#FFF",
				"fill-opacity": 0.8
			}
		}';
		
//global variables
$points = [];

/*=================== FUNCTIONS ===================*/

//calculate distance (haversine)
function calcCrow($lat1,$lng1,$lat2,$lng2) {
	$R = 6371e3; //earth radius in meters
	$rad = pi()/180; //1 radian
	$phi1 = $lat1 * $rad; //φ, λ in radians
	$phi2 = $lat2 * $rad;
	$dPhi = ($lat2 - $lat1) * $rad;
	$dLambda = ($lng2 - $lng1) * $rad;
	$a = pow(sin($dPhi/2),2) + cos($phi1) * cos($phi2) * pow(sin($dLambda/2),2);
	$c = 2 * atan2(sqrt($a), sqrt(1 - $a));
	return $R * $c; //in metres
}

//returns a point on a line segment
function getPoint($factor, $lat1, $lon1, $lat2, $lon2) {
  if ($lon1 < 0) { $lon1 += 360; }
  if ($lon2 < 0) { $lon2 += 360; }
  $lonPoint = round($lon1 - $factor * ($lon1 - $lon2), 6);
  $latPoint = round($lat1 - $factor * ($lat1 - $lat2), 6);
	return "{$lonPoint},{$latPoint}";
}

//collects distance markers in the $points array
function getMkrCoords($coordinates, $mkrDist) {
	global $points;

	$currentDistance = 0;
	$target = $mkrDist;
	for ($i = 0; $i < count($coordinates) - 1; $i++) {
		$thisDistance = calcCrow($coordinates[$i][1], $coordinates[$i][0], $coordinates[$i+1][1], $coordinates[$i+1][0]);
		while ($target < $currentDistance + $thisDistance) {
			$legDistance = $target - $currentDistance;
			$factor = $legDistance / $thisDistance;
			$points[] = getPoint($factor, $coordinates[$i][1], $coordinates[$i][0], $coordinates[$i+1][1], $coordinates[$i+1][0]);
			$target += $mkrDist;
		}
		$currentDistance += $thisDistance;
	}
	 return $currentDistance; //total distance
}

/*===================== START =====================*/

ini_set( 'serialize_precision', -1 ); //avoid decimals added by json_encode

//get the file content
if (!isset($_GET['file'])) { exit ("No file specified!<br><br>Format: https://www.yoursite.dk/dmarkers.php?file=path-to-geojson-file"); }
$fileName = $_GET['file'] . (substr($_GET['file'],-8) != ".geojson" ? ".geojson" : '');
if (!is_file($fileName)) { exit ("File <b>{$fileName}</b> not found!"); }
$profile = (!isset($_GET['profile']) or $_GET['profile']) ? '1' : '0';
$geojStr = file_get_contents($fileName);
$geojStr = "{\n\t\"distanceMarkers\": 1,\n\t\"profile\": {$profile}," . $globProps . substr($geojStr,1);
//clean up file
$geojNew = str_replace("  ","\t",$geojStr); //indent with tabs
$geojNew = preg_replace('~(\d.\d{6})\d+~','$1',$geojNew); //truncate lat/lng to 6 decimals
$geojNew = preg_replace('~\[[\n\r\s]*([-\d\.]+),[\n\r\s]*([-\d\.]+)(?:(,)[\n\r\s]*([-\d\.]+))?[^\]]*]~','[$1,$2$3$4]',$geojNew); //clean up coordinates
//convert to object
$geojObj = json_decode($geojNew);

//init
$lsNr = 0; //LineString number
$gjPoints = ''; //gj file content

//process LineString features
foreach($geojObj->features as $fNr =>$feature) {
	if($feature->geometry->type == 'LineString') {
		$lsNr++;
		//make first point
		$fCoords = $feature->geometry->coordinates[0];
		$gjPoints .= str_replace(['<lola>','<dist>','<desc>'], ["{$fCoords[0]},{$fCoords[1]}",'0 km','Start'], $gjPointsT);
		//make middle points
		$totalDist = getMkrCoords($feature->geometry->coordinates, 1000);
		foreach($points as $k => $lola) {
			$km = $k + 1;
			$gjPoints .= str_replace(['<lola>','<dist>','<desc>'], ["{$lola}","{$km} km",''], $gjPointsT);
		}
		$points = []; //empty points array
		//make last point
		$lCoords = end($feature->geometry->coordinates);
		$totalDist = strval(round($totalDist / 1000, 2)) . " km";
		$gjPoints .= str_replace(['<lola>','<dist>','<desc>'], ["{$lCoords[0]},{$lCoords[1]}",$totalDist,'End'], $gjPointsT);
		//report
		echo "• LineString: <b>{$lsNr}</b> - Points: <b>{$km}</b> - Total distance: <b>{$totalDist}</b><br>";
	}
}
//save file
$newFileName = str_replace('.geojson','-dm.geojson',$fileName);
$geojStr = preg_replace('~[\n\s]*\][\n\s]*}[\n\s]*$~',"{$gjPoints}\n  ]\n}",$geojNew); //geojson string
$result = file_put_contents($newFileName, $geojStr);
$elpro = $profile ? 'yes' : 'no';
echo $result ? "<br>File saved: <b>{$newFileName}</b> - Elevation profile: <b>{$elpro}</b> - Bytes: <b>".number_format($result,0,",",".")."</b>." : "Error saving file!";
?>
